/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item.tools;

import codechicken.lib.raytracer.RayTracer;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.init.AvaritiaTags;
import morph.avaritia.util.ToolHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class InfinityPickaxeItem
extends PickaxeItem {
    public static final UUID KNOCKBACK_UUID = UUID.fromString("93253e7f-250d-4320-9c27-6522a75cebf8");

    public InfinityPickaxeItem(Item.Properties properties) {
        super(AvaritiaModContent.INFINITY_TIER, 6, -2.8f, properties);
        this.f_40979_ = AvaritiaTags.Blocks.MINEABLE_WITH_INFINITY_PICKAXE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && !level.f_46443_) {
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack) < 10) {
                stack.m_41663_(Enchantments.f_44987_, 10);
            }
            stack.m_41784_().m_128379_("hammer", !stack.m_41784_().m_128471_("hammer"));
            player.m_6674_(hand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (stack.m_41782_() && stack.m_41784_().m_128471_("hammer")) {
            return 5.0f;
        }
        return super.m_8102_(stack, state);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap map = HashMultimap.create((Multimap)super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlot.MAINHAND && stack.m_41782_() && stack.m_41784_().m_128471_("hammer")) {
            map.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(KNOCKBACK_UUID, "Tool modifier", 20.0, AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult traceResult;
        if (stack.m_41782_() && stack.m_41784_().m_128471_("hammer") && (traceResult = RayTracer.retrace((Player)player, (double)10.0, (ClipContext.Block)ClipContext.Block.OUTLINE)).m_6662_() != HitResult.Type.MISS) {
            this.breakOtherBlock(player, stack, pos, traceResult.m_82434_());
        }
        return false;
    }

    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, Direction sideHit) {
        Level level = player.f_19853_;
        BlockState state = level.m_8055_(pos);
        if (!stack.m_41735_(state)) {
            return;
        }
        if (level.m_46859_(pos)) {
            return;
        }
        boolean doY = sideHit.m_122434_() != Direction.Axis.Y;
        int range = 8;
        BlockPos min = pos.m_142082_(-range, doY ? -1 : -range, -range);
        BlockPos max = pos.m_142082_(range, doY ? range * 2 - 2 : range, range);
        ToolHelper.aoeBlocks(player, stack, level, pos, min, max, null, true);
    }

    public boolean m_41386_(DamageSource source) {
        return source == DamageSource.f_19317_;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }
}

